// $Id: BasicApplication.m,v 1.9 2002/08/24 19:08:19 hns Exp $
//
//  Application.m
//  CocoaBasic
//
//  Created by Dr. H. Nikolaus Schaller on Sat Jun 15 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import "BasicApplication.h"
#import "BasicDocument.h"	// for Content_Class_Type_UserDefined

@implementation BasicApplication

- (IBAction) orderFrontPreferencesPanel:(id)Sender
{
	[confirmSettings setState:getPreference(Preferences_confirmSettings, bool)?NSOnState:NSOffState];
	[keepBackup setState:getPreference(Preferences_keepBackup, bool)?NSOnState:NSOffState];
	[autoSave setState:getPreference(Preferences_autoSave, bool)?NSOnState:NSOffState];
	[saveBeforeRun setState:getPreference(Preferences_saveBeforeRun, bool)?NSOnState:NSOffState];
	[showDebugRun setState:getPreference(Preferences_showDebugRun, bool)?NSOnState:NSOffState];
	[compileApplic setState:getPreference(Preferences_compileApplic, bool)?NSOnState:NSOffState];
	[showApplic setState:getPreference(Preferences_showApplic, bool)?NSOnState:NSOffState];
	[developmentLanguage setObjectValue:getPreference(Preferences_devLang, string)];
	[preferences orderFront:Sender];
}

- (IBAction) savePreferences:(id)Sender
{ // set preferences to UserDefaults and synchronize
	[[NSUserDefaults standardUserDefaults] setBool:([confirmSettings state]==NSOnState) forKey:Preferences_confirmSettings];
	[[NSUserDefaults standardUserDefaults] setBool:([keepBackup state]==NSOnState) forKey:Preferences_keepBackup];
	[[NSUserDefaults standardUserDefaults] setBool:([autoSave state]==NSOnState) forKey:Preferences_autoSave];
	[[NSUserDefaults standardUserDefaults] setBool:([saveBeforeRun state]==NSOnState) forKey:Preferences_saveBeforeRun];
	[[NSUserDefaults standardUserDefaults] setBool:([showDebugRun state]==NSOnState) forKey:Preferences_showDebugRun];
	[[NSUserDefaults standardUserDefaults] setBool:([compileApplic state]==NSOnState) forKey:Preferences_compileApplic];
	[[NSUserDefaults standardUserDefaults] setBool:([showApplic state]==NSOnState) forKey:Preferences_showApplic];
	[[NSUserDefaults standardUserDefaults] setObject:[developmentLanguage objectValue] forKey:Preferences_devLang];
	[[NSUserDefaults standardUserDefaults] synchronize];
	[preferences performClose:Sender];
}

- (NSDictionary *) factorySettings
{
	NSMutableDictionary *d;
	// should better read from some resources file....
	d=[NSMutableDictionary dictionaryWithCapacity:10];
	[d setObject:[NSNumber numberWithBool:YES] forKey:Preferences_confirmSettings];
	[d setObject:[NSNumber numberWithBool:YES] forKey:Preferences_keepBackup];
	[d setObject:[NSNumber numberWithBool:NO] forKey:Preferences_autoSave];
	[d setObject:[NSNumber numberWithBool:YES] forKey:Preferences_saveBeforeRun];
	[d setObject:[NSNumber numberWithBool:NO] forKey:Preferences_showDebugRun];
	[d setObject:[NSNumber numberWithBool:NO] forKey:Preferences_compileApplic];
	[d setObject:[NSNumber numberWithBool:YES] forKey:Preferences_showApplic];
	[d setObject:@"English" forKey:Preferences_devLang];
	return d;
}

- (IBAction) factorySettings:(id)Sender
{ // restore factory settings
	NSDictionary *d=[self factorySettings];
	NSEnumerator *enumerator=[d keyEnumerator];
	NSString *key;	
#if 0
	NSLog(@"%@", [self factorySettings]);
#endif
	while((key = [enumerator nextObject]))
		[[NSUserDefaults standardUserDefaults] setObject:[d objectForKey:key] forKey:key];
	[self orderFrontPreferencesPanel:Sender];
}

- (IBAction) orderFrontStandardAboutPanel:(id) Sender
{
	NSBundle *thisBundle;
	NSString *bundleToLoadPath;
	NSBundle *bundleToLoad;
	Class loadedClass;

	thisBundle=[NSBundle mainBundle];
#if 0
	NSLog(@"this bundle:%@\n", thisBundle);
#endif
	
	bundleToLoadPath=[thisBundle pathForResource:@"About" ofType:@"bundle"];	// path for bundle to load
#if 0
	NSLog(@"bundle path:%@\n", bundleToLoadPath);
#endif
	bundleToLoad = [NSBundle bundleWithPath:bundleToLoadPath];	// locate bundle to load
#if 0
	NSLog(@"bundle to load:%@\n", bundleToLoad);
#endif
	loadedClass = [bundleToLoad principalClass];
#if 0
	NSLog(@"loaded class:%@\n", loadedClass);
#endif
	// if exists
	[loadedClass open];
}

+ (NSDictionary *) keyword:(NSString *) sym
{ // get keyword ressource
	static NSDictionary *kw;
	if(kw == nil)
		{ // load from resources file
		NSString *sympath=[[NSBundle bundleForClass:[self class]] pathForResource:@"Keywords" ofType:@"plist"];
		kw=[[NSDictionary dictionaryWithContentsOfFile:sympath] retain];
#if 0
		NSLog(@"dictionary %@ loaded from %@", sym, sympath);
#endif
		}
	return [kw objectForKey:sym];
}

- (void) awakeFromNib
{
	NSBundle *thisBundle;
	NSString *bundleToLoadPath;
	NSBundle *bundleToLoad;
#if 0
	NSLog(@"[Application awakeFromNib: %@]\n", self);
#endif

	// set values
	[[NSUserDefaults standardUserDefaults] registerDefaults:[self factorySettings]];

	thisBundle=[NSBundle mainBundle];
#if 0
	NSLog(@"this bundle:%@\n", thisBundle);
#endif

		{ // everythink ok - load plugin classes
		NSArray *theplugins=[NSBundle pathsForResourcesOfType:@"bundle" inDirectory:[[NSBundle mainBundle] builtInPlugInsPath]];
		NSEnumerator* enumerator = [theplugins objectEnumerator];
		NSString* pluginPath;
#if 0
		NSLog(@"load plugins\n");
#endif
		while((pluginPath=[enumerator nextObject]))
			{
			if([[[pluginPath lastPathComponent] stringByDeletingPathExtension] isEqualToString:Content_Class_Type_UserDefined])
				NSRunInformationalAlertPanel(@"Plugin Loader Warning",
					@"You can't load a plugin with the name %@", @"Ok", nil, nil, Content_Class_Type_UserDefined, nil);

			else
				{
#if 0
				Class c=
#endif
				[[NSBundle bundleWithPath:pluginPath] principalClass];

#if 0
			NSLog(@"Plugin loaded %@ - principal class %@", pluginPath, NSStringFromClass(c));
#endif
				}
			}
	[[NSDocumentController sharedDocumentController] newDocument:self];	// make new project
}

// menu and user interface validation

- (BOOL) validateMenuItem:(id <NSMenuItem>) item
{
//	SEL sel=[item action];	// check on action - so that the title can be changed
#if 0
	NSLog(@"BasicApplication validateMenuItem %@ %@", [item title], NSStringFromSelector([item action]));
#endif
	return [super validateMenuItem:item];	// default
}

@end
